<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });
Route::group(['prefix'=>'products'],function(){
Route::get('/',[ProductController ::class,'index']);
Route::get('/show',[ProductController::class,'show']);
Route::delete('/delete',[ProductController ::class,'destroy']);
Route::post('/',[ProductController ::class,'store']);
Route::post('/update',[ProductController ::class,'update']);



Route::get('/orderbylikes',[ProductController ::class,'getMostLikedProducts']);
Route::get('/orderbyorders',[ProductController ::class,'getMostOrderedProducts']);
Route::get('/hasdiscounts',[ProductController ::class,'getOnSaleProducts']);
Route::get('/related',[ProductController ::class,'getRelatedProducts']);

});


