<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name_ar');
            $table->string('name_en');
            $table->foreignId('category_id')->constrained('categories')->onDelete('cascade')->onUpdate('cascade');
            $table->unsignedBigInteger('tag_id')->nullable()->default(1);
            $table->foreign('tag_id')->references('id')->on('tags')->onDelete('set null');
            $table->string('description_ar')->default("لا يوجد وصف لهذا المنتج حالياً");
            $table->string('description_en')->default("There is no description to this product right now");
            $table->integer('purchasing_price');
            $table->integer('selling_price');
            $table->integer('quantity');
            $table->string('main_photo');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
