<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\SubCategory;

class Product extends Model
{
    use HasFactory;

        /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name_ar',
        'name_en',
        'category_id',
        'tag_id',
        'description_ar',
        'description_en',
        'purchasing_price',
        'selling_price',
        'quantity',
        'main_photo'
    ];


    public function photos()
    {
        return $this->hasMany(Photo::class);    
    }
    public function orders()
    {
        return $this->belongsToMany(Order::class,'order_details')->as('order_details');    
    }
    public function category()
    {
        return $this->belongsTo(Category::class,'category_id');
    }
    public function tag()
    {
        return $this->belongsTo(Tag::class);
    }
}
