<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderDetail extends Model
{
    use HasFactory;
    protected $fillable = [
        
        'order_id',
        'product_id',
        'price',
        'quantity'
    ];

    public function orders()
    {
        return $this->belongsto(Order::class);    
    }

    public function products()
    {
        return $this->belongsto(Product::class);    
    }
}
