<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\Product;

class Order extends Model
{
    use HasFactory;
    protected $fillable = [
        'total_price',
        'paid',
        'payment_stauts',
        'deliever_stauts',
        'user_id'
    ];

        /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'paid' => 'boolean',
    ];

    public function user (){
        return $this->belongsTo(User::class);

    }

    public function products()
    {
        return $this->belongstoMany(Product::class,'order_details')->as('order_details');    
    }
}
