<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Laravel\Sanctum\Sanctum;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Password;
use App\Models\User;

class UserController extends Controller
{
    

    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'first_name' => 'required',
            'last_name' => 'required',
            'phone' => 'required|unique:users',
            'email' => 'required|email|unique:users',
            'password' => 'required',
            'c_password' => 'required|same:password',
        ]);
   
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }

            $user = User::create([
            'first_name'=> request('first_name'),
            'last_name'=> request('last_name'),
            'phone' =>request('phone'),
            'email'=>request('email'),
            'password'=>bcrypt(request('password'))
        ]);
        $token = $user->createToken('authToken',['user'])->plainTextToken;
                   
        event(new Registered($user));
       $response = [
            'user' => $user,
            'token' => 'u'.'_'.$token,
            'message'=>'User created successfully'
        ];

        return response()->json($response, 201);
        }
       
    
   
    /**
     * Login api
     *
     * @return \Illuminate\Http\Response
     */
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
  
            'email' => 'required|email',
            'password' => 'required',
        ]);
   
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $email=request('email');
        $password=request('password');
            $userByEmail = User::where('email', $email)->first();
        if ($userByEmail!=null){
          
                $user=User::find($userByEmail->id);
                if(hash::check($password,$user->password)) {
                    $role=$user->role;
                    if($role == 'ADM'){
                        $token = $user->createToken('authToken',['admin'])->plainTextToken;
                        $response = [
                          'user' => $user,
                          'token' => 'a'.'_'.$token,
                          'message'=>'Admin logged in successfully'
                      ];
            
                    return response($response, 201);

                    }
                    else{
                    $token = $user->createToken('authToken',['user'])->plainTextToken;
                    $response = [
                      'user' => $user,
                      'token' => 'u'.'_'.$token,
                      'message'=>'User logged in successfully'
                  ];
        
                return response($response, 201); }}
                else{
                    return response(["error"], 201);

                }
            }

       
    }
    public function logout() {
        try {auth('sanctum')->user()->tokens()->delete();

    return [
        'message' => 'Logged out'
    ];
    }catch (\Error $ex) {
        return  response()->json(["error"=>$ex->getMessage(),"message"=>"The token is not valid or expired" ],401);
    }catch (\Exception $ex) {
        return  response()->json(["error"=>$ex->getMessage(),"message"=>"The token is not valid or expired" ],401);
    }}

    
    public function updateemail(Request $request)
    {
        $validator = Validator::make($request->all(), [
  
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
        ]);
   
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $user_id = request('id');
        $user=User::find($user_id);
        if ($user!=null){
            
            if(request('email') != $user->email){
                $user->email_verified_at = null;
                $user->sendEmailVerificationNotification();
            }
 
            $user->update(
                [
           
            'email'=>request('email')
                ]
            );
            return response($user,200);

        }
        else {
            return response()->json(['error'=>' this id does not exit to modify '],404);
        }
    }

    public function updatename(Request $request)
    {
        $validator = Validator::make($request->all(), [
  
            'first_name' => ['required', 'string', 'max:255'],
            'last_name' => ['required', 'string', 'max:255'],
        ]);
   
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $user_id = request('id');
        $user=User::find($user_id);
        if ($user!=null){

            $user->update(
                [
            'first_name'=> request('first_name'),
            'last_name'=> request('last_name'),
           
                ]
            );
            return response($user,200);

        }
        else {
            return response()->json(['error'=>' this id does not exit to modify '],404);
        }
    }

    public function updatephone(Request $request)
    {
        $validator = Validator::make($request->all(), [
  
            'phone' => 'required|regex:/^\+\d{3}[0-9]{9}/'
       
        ]);
   
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $user_id = request('id');
        $user=User::find($user_id);
        if ($user!=null){

            $user->update(
                [
            'phone' =>request('phone'),
           
           
                ]
            );
            return response($user,200);

        }
        else {
            return response()->json(['error'=>' this id does not exit to modify '],404);
        }
    }


    public function updatepassword(Request $request){  
        $validator = Validator::make($request->all(), [
            'old_password'=>'required',
            'new_password' => 'required',
            'c_password' => 'required|same:password',
        ]);
   
        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }

        $user_id = request('id');
        $user=User::find($user_id);
        if ($user!=null){
       
        if(hash::check(request('old_password'),$user->password)) {
          $user->password=Hash::make(request('new_password'));
          $user->save();
      
          return response()->json(["msg" => 'Your password changed ']);
        }
        
        return response()->json(["msg" => 'some thing error']);
    }

    }
  

}
