<?php

namespace App\Http\Controllers;

use App\Models\Tag;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class TagController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $tags=Tag::all();
        return response()->json($tags,200);
        
    }

    public function getTagsNamesforDropDown()
    {
        //
        $tags=Tag::select('id','name_ar','name_en')->get();
        return response()->json($tags,200);
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Support\Facades\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
   
        $validator=Validator::make($request->all(),
        [
            'name_ar'=>'required|max:255',
            'name_en'=>'required|max:255',
            'background_color'=>'required',
            
        ]);

        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }

        try{
       
         $tag= Tag::create([
            'name_ar'=>$request->name_ar,
            'name_en'=>$request->name_en,
            'background_color'=>$request->background_color
            ]
        );


        return response()->json($tag,201);
        }
        catch(Exception $ex){
            return response()->json(["message"=>$ex->getMessage()],400);
            }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Tag  $tag
     * @return \Illuminate\Http\Response
     */
    public function show(Tag $tag)
    {
        //
        $tag_id = request('id');
        $tag= Tag::find($tag_id);
        if ($tag !=null){
            return response($tag,200);
        }
        else {
            return response()->json(['error'=>' this id does not exist '],404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateTagRequest  $request
     * @param  \App\Models\Tag  $tag
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Tag $tag)
    {
        //
        $validator=Validator::make($request->all(),
        [
            'name_ar'=>'required',
            'name_en'=>'required' ,
            'background_color'=>'required'
            
        ]);

        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $tag_id = $request->id;
        $tag = Tag::find($tag_id);
        if ($tag !=null){

            $tag->update([
                'name_ar' => $request->name_ar ,
                'name_en' => $request->name_en ,
                'background_color' => $request->background_color ,
                          ]


            );

            return response($tag,200);

        }
        else {
            return response()->json(['error'=>' this id does not exit to modify '],404);
        }
    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Tag  $tag
     * @return \Illuminate\Http\Response
     */
    public function destroy(Tag $tag)
    {
        //
        try {
            $tag_id = request('id');
            $tag= Tag::find($tag_id);
            $tag->delete();
            return response()->json([$tag,'status'=>"success",'message' => "Tag deleted successfully"],200);
    
 }catch (\Exception $ex) {
         return response()->json(["message"=>$ex->getMessage()], 400);
     }
    }
}
